#ifndef _SQLCLASS_CPP
#define _SQLCLASS_CPP
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>

#include "CSQL.H"
#include "CRecordSet.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CSQL::CSQL()
{
    Connected = false;
    Disconnect();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CSQL::~CSQL()
{
    Disconnect();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSQL::Connect(char *Driver, char *Server, char *UID, char *PWD, char *Database)
{
    SQLRETURN Result;
    char ConnectString[MAXSQLBUFLEN];

    if(Connected)
	{
        return false;
	}

    bThrowErrors = true;

    sprintf(ConnectString, "DRIVER=%s; SERVER=%s; UID=%s; PWD=%s; DATABASE=%s;", Driver, Server, UID, PWD, Database);

    SQLCHAR ConnStrOut[MAXSQLBUFLEN];
    SQLSMALLINT cbConnStrOut = 0;

    // Allocate the environment handle
    Result = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &SQLEnvironment);
    if(!SQL_SUCCEEDED(Result))
    {
        return false;
    }

    // Set the environment attributes
    Result = SQLSetEnvAttr(SQLEnvironment, SQL_ATTR_ODBC_VERSION, (void *) SQL_OV_ODBC3, 0);
    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        return false;
    }

    // Allocate the connection handle
    Result = SQLAllocHandle(SQL_HANDLE_DBC, SQLEnvironment, &SQLConnection);
    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        return false;
    }

    // Set login timeout to 5 seconds.
    SQLSetConnectOption(SQLConnection, SQL_LOGIN_TIMEOUT, 5);
    SQLSetConnectOption(SQLConnection, SQL_CURSOR_TYPE, SQL_CURSOR_STATIC);

    // Connect
    Result = SQLDriverConnect(
        SQLConnection,            // Connection handle
        NULL,                     // Window handle
        (SQLCHAR *)ConnectString, // Input connect string
        SQL_NTS,                  // Null-terminated string
        ConnStrOut,               // Address of output buffer
        MAXSQLBUFLEN,             // Size of output buffer
        &cbConnStrOut,            // Address of output length
        SQL_DRIVER_NOPROMPT
    );

    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        return false;
    }

    Connected = true;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSQL::GetErrorMessage(char *ReturnChar, HSTMT StatementHandle)
{
    if(Connected)
	{
	    SQLCHAR     szSqlState[20];
	    SQLINTEGER  ssErr;
	    SQLSMALLINT cbErrorMsg;

	    return SQL_SUCCEEDED(SQLError(SQLEnvironment, SQLConnection, StatementHandle, szSqlState, &ssErr, (SQLCHAR *)ReturnChar, MAXSQLCONNOUT, &cbErrorMsg));
	}
	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSQL::ThrowErrorIfSet(HSTMT hStmt)
{
	if(bThrowErrors == true)
	{
		return ThrowError(hStmt);
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSQL::ThrowError(HSTMT hStmt)
{
	char sErrorMsg[10240];

	if(GetErrorMessage(sErrorMsg, hStmt))
	{
		MessageBox(GetActiveWindow(), sErrorMsg, "CSQL::Error", MB_ICONERROR);
		return true;
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CSQL::Disconnect(void)
{
    if(Connected)
    {
        SQLDisconnect(SQLConnection);
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
    }

    SQLConnection = NULL;
    SQLEnvironment = NULL;

    Connected = false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSQL::ExecuteNonQuery(char *Statement)
{
    if(!Connected)
        return false;

    SQLRETURN Result = 0;

	bool bResult = false;

    HSTMT stmtHandle;

	Result = SQLAllocHandle(SQL_HANDLE_STMT, SQLConnection, &stmtHandle);
    if(SQL_SUCCEEDED(Result))
    {
        Result = SQLPrepare(stmtHandle, (unsigned char *)Statement, strlen(Statement));
        if(SQL_SUCCEEDED(Result))
        {
            Result = SQLExecute(stmtHandle);
            if(Result == SQL_SUCCESS || Result == SQL_SUCCESS_WITH_INFO || Result == SQL_NO_DATA)
            {
                bResult = true;
            } else ThrowErrorIfSet(stmtHandle);
        } else ThrowErrorIfSet(stmtHandle);
    } else ThrowErrorIfSet(stmtHandle);

	SQLFreeHandle(SQL_HANDLE_STMT, stmtHandle);

	stmtHandle = NULL;
    
	return bResult;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSQL::Execute(char *Statement, CRecordSet *MyRS)
{
	if(!Connected)
	{
        return false;
	}

    SQLRETURN Result = 0;

    Result = SQLAllocHandle(SQL_HANDLE_STMT, SQLConnection, &MyRS->hSTMT);
    if(SQL_SUCCEEDED(Result))
    {
        Result = SQLPrepare(MyRS->hSTMT, (unsigned char *)Statement, strlen(Statement));
        if(SQL_SUCCEEDED(Result))
        {
			Result = SQLExecute(MyRS->hSTMT);
            if(Result == SQL_SUCCESS || Result == SQL_SUCCESS_WITH_INFO || Result == SQL_NO_DATA)
            {
				if(SQLRowCount(MyRS->hSTMT, &MyRS->RowCount) != SQL_SUCCESS)
				{
					MyRS->RowCount = 0;
				}

				if(SQLNumResultCols(MyRS->hSTMT, (SQLSMALLINT *) &MyRS->ColCount) != SQL_SUCCESS)
				{
					MyRS->ColCount = 0;
				}

				return true;
            } else ThrowErrorIfSet(MyRS->hSTMT);
        } else ThrowErrorIfSet(MyRS->hSTMT);
    } else ThrowErrorIfSet(MyRS->hSTMT);
/*

    if(!Connected)
	{
        return false;
	}

    SQLRETURN Result = 0;

    Result = SQLAllocHandle(SQL_HANDLE_STMT, SQLConnection, &MyRS->hSTMT);
    if(SQL_SUCCEEDED(Result))
    {
		//Result = SQLExecDirect(MyRS->hSTMT, Statement, SQL_NTS);
		Result = SQLExecDirect(MyRS->hSTMT, (unsigned char *)Statement, strlen(Statement));

		if(Result == SQL_SUCCESS || Result == SQL_SUCCESS_WITH_INFO || Result == SQL_NO_DATA)
		{
			if(SQLRowCount(MyRS->hSTMT, &MyRS->RowCount) != SQL_SUCCESS)
			{
				MyRS->RowCount = 0;
			}

			if(SQLNumResultCols(MyRS->hSTMT, (SQLSMALLINT *) &MyRS->ColCount) != SQL_SUCCESS)
			{
				MyRS->ColCount = 0;
			}

			return true;
		}
	}
*/
    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
